<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\Admin\TenantController;
use App\Http\Controllers\Admin\TenantUserController;

/**
 * TEMP DEV MODE (NO AUTH, NO TENANCY)
 * - React app is public
 * - API is public
 * - Admin pages are public
 */

Route::get('/', fn () => redirect('/app'));

/**
 * Super Admin UI (TEMP: public)
 */
Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');

    Route::get('/tenants', [TenantController::class, 'index'])->name('tenants.index');
    Route::get('/tenants/create', [TenantController::class, 'create'])->name('tenants.create');
    Route::post('/tenants', [TenantController::class, 'store'])->name('tenants.store');
    Route::delete('/tenants/{tenant}', [TenantController::class, 'destroy'])->name('tenants.destroy');

    Route::post('/tenants/{tenant}/users', [TenantUserController::class, 'store'])->name('tenants.users.store');
});

/**
 * React SPA (public)
 */
Route::get('/app/{any?}', fn () => view('spa'))->where('any', '.*');

/**
 * API (public)
 */
// Route::prefix('api')->group(function () {
//     Route::apiResource('offers', \App\Http\Controllers\Api\OfferController::class);
//     Route::apiResource('profiles', \App\Http\Controllers\Api\ProfileController::class);
//     Route::apiResource('irons', \App\Http\Controllers\Api\IronController::class);
//     Route::apiResource('glass-types', \App\Http\Controllers\Api\GlassTypeController::class);
//     Route::apiResource('accessories', \App\Http\Controllers\Api\AccessoryController::class);
// });



use Illuminate\Support\Facades\DB;

Route::get('/__db_test', function () {
    DB::connection('central')->table('offers')->insert([
        'name' => 'test-offer',
        'created_at' => now(),
        'updated_at' => now(),
    ]);

    return [
        'central_offers' => DB::connection('central')->table('offers')->count(),
        'default_offers' => DB::table('offers')->count(),
        'default_conn' => config('database.default'),
    ];
});


// use App\Http\Controllers\Api\PositionController;

// Route::prefix('offers/{offer}')->group(function () {
//     Route::get('/positions', [PositionController::class, 'index']);
//     Route::post('/positions', [PositionController::class, 'store']);
//     Route::post('/positions/sync', [PositionController::class, 'sync']); // ✅ best for React
// });

// Route::get('/positions/{position}', [PositionController::class, 'show']);
// Route::match(['put','patch'], '/positions/{position}', [PositionController::class, 'update']);
// Route::delete('/positions/{position}', [PositionController::class, 'destroy']);
