@extends('layouts.app')

@section('content')
<div class="max-w-6xl mx-auto p-6">
    <div class="flex items-center justify-between mb-6">
        <div>
            <h1 class="text-2xl font-bold">Tenants</h1>
            <p class="text-sm text-gray-500">Manage companies + access</p>
        </div>
        <a href="{{ route('admin.tenants.create') }}"
           class="px-4 py-2 rounded-lg bg-black text-white hover:opacity-90">
            + Add Tenant
        </a>
    </div>

    @if(session('success'))
        <div class="mb-4 p-3 rounded bg-green-50 text-green-800 border border-green-200">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white border rounded-xl overflow-hidden">
        <table class="w-full text-sm">
            <thead class="bg-gray-50">
                <tr class="text-left">
                    <th class="p-3">Company</th>
                    <th class="p-3">Tenant ID</th>
                    <th class="p-3">Domain(s)</th>
                    <th class="p-3">Created</th>
                    <th class="p-3 text-right">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($tenants as $t)
                    <tr class="border-t">
                        <td class="p-3 font-medium">
                            {{ data_get($t->data, 'name', '—') }}
                        </td>
                        <td class="p-3 text-gray-600">{{ $t->id }}</td>
                        <td class="p-3">
                            <div class="flex flex-col gap-1">
                                @foreach($t->domains as $d)
                                    <span class="inline-flex px-2 py-1 rounded bg-gray-100 w-fit">
                                        {{ $d->domain }}
                                    </span>
                                @endforeach
                            </div>
                        </td>
                        <td class="p-3 text-gray-600">{{ $t->created_at?->format('Y-m-d') }}</td>
                        <td class="p-3 text-right">
                            <form method="POST" action="{{ route('admin.tenants.destroy', $t) }}"
                                  onsubmit="return confirm('Delete this tenant?')">
                                @csrf
                                @method('DELETE')
                                <button class="px-3 py-1.5 rounded-lg border hover:bg-gray-50">
                                    Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr><td class="p-6 text-gray-500" colspan="5">No tenants yet.</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $tenants->links() }}
    </div>
</div>
@endsection
