@extends('layouts.app')

@section('content')
<div class="max-w-2xl mx-auto p-6">
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Add Tenant</h1>
        <p class="text-sm text-gray-500">Creates company + domain + first tenant user</p>
    </div>

    @if($errors->any())
        <div class="mb-4 p-3 rounded bg-red-50 text-red-800 border border-red-200">
            <ul class="list-disc ml-5">
                @foreach($errors->all() as $e) <li>{{ $e }}</li> @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('admin.tenants.store') }}" class="bg-white border rounded-xl p-5 space-y-4">
        @csrf

        <div>
            <label class="text-sm font-semibold">Company Name</label>
            <input name="company_name" value="{{ old('company_name') }}"
                   class="mt-1 w-full border rounded-lg px-3 py-2" placeholder="Company ABC">
        </div>

        <div>
            <label class="text-sm font-semibold">Domain</label>
            <input name="domain" value="{{ old('domain') }}"
                   class="mt-1 w-full border rounded-lg px-3 py-2"
                   placeholder="companyabc.yourapp.com">
            <p class="text-xs text-gray-500 mt-1">Use full domain (subdomain).</p>
        </div>

        <div class="border-t pt-4">
            <h3 class="font-semibold">First Tenant Admin</h3>
            <p class="text-xs text-gray-500">This user will be created inside the tenant database.</p>
        </div>

        <div>
            <label class="text-sm font-semibold">Admin Name</label>
            <input name="admin_name" value="{{ old('admin_name') }}"
                   class="mt-1 w-full border rounded-lg px-3 py-2" placeholder="Company Admin">
        </div>

        <div>
            <label class="text-sm font-semibold">Admin Email</label>
            <input name="admin_email" value="{{ old('admin_email') }}"
                   class="mt-1 w-full border rounded-lg px-3 py-2" placeholder="admin@company.com">
        </div>

        <div>
            <label class="text-sm font-semibold">Admin Password</label>
            <input type="password" name="admin_pass"
                   class="mt-1 w-full border rounded-lg px-3 py-2" placeholder="Min 8 chars">
        </div>

        <div class="flex gap-3 justify-end pt-2">
            <a href="{{ route('admin.tenants.index') }}"
               class="px-4 py-2 rounded-lg border hover:bg-gray-50">Cancel</a>
            <button class="px-4 py-2 rounded-lg bg-black text-white hover:opacity-90">
                Create Tenant
            </button>
        </div>
    </form>
</div>
@endsection
