import { useEffect, useRef, useState } from "react";

export default function useMeasure() {
  const ref = useRef(null);
  const [rect, setRect] = useState({ width: 1100, height: 540 });

  useEffect(() => {
    const el = ref.current;
    if (!el) return;
    const ro = new ResizeObserver((entries) => {
      const r = entries[0]?.contentRect;
      if (!r) return;
      setRect({ width: Math.max(300, r.width), height: Math.max(240, r.height) });
    });
    ro.observe(el);
    return () => ro.disconnect();
  }, []);

  return [ref, rect];
}
