import React from "react";
import { UI } from "../../constants/ui";
import { Pill } from "../../components/ui/Pill";
import { Btn } from "../../components/ui/Btn";
import { money } from "../../utils/money";

export function OfferCard({ offer, materials, onOpen }) {
  const positions = offer.positions || [];
  const sum = positions.reduce((s, p) => s + (p.total || 0), 0);

  const profileName = materials.profiles.find((p) => p.id === offer.profileId)?.name || offer.profileName || "—";
  const ironName = materials.irons.find((i) => i.id === offer.ironId)?.name || offer.ironName || "—";

  return (
    <div
      style={{
        border: `1px solid ${UI.border}`,
        borderRadius: 18,
        background: "#fff",
        boxShadow: UI.shadow,
        padding: 14,
        display: "flex",
        flexDirection: "column",
        gap: 10,
        minWidth: 0,
      }}
    >
      <div style={{ display: "flex", alignItems: "flex-start", justifyContent: "space-between", gap: 10 }}>
        <div style={{ display: "flex", flexDirection: "column", gap: 6, minWidth: 0 }}>
          <div style={{ fontSize: 12, color: UI.muted }}>Ofertë</div>
          <div style={{ fontSize: 14, fontWeight: 900, whiteSpace: "nowrap", overflow: "hidden", textOverflow: "ellipsis" }}>
            {offer.name}
          </div>
          <div style={{ display: "flex", gap: 8, flexWrap: "wrap" }}>
            <Pill tone="soft">Marzha: {offer.margin}%</Pill>
            <Pill tone="soft">Pozicione: {positions.length}</Pill>
            <Pill tone="soft">Profil: {profileName}</Pill>
            <Pill tone="soft">Arm: {ironName}</Pill>
          </div>
        </div>

        <div style={{ textAlign: "right" }}>
          <div style={{ fontSize: 12, color: UI.muted }}>Totali</div>
          <div style={{ fontSize: 18, fontWeight: 950 }}>€ {money(sum)}</div>
        </div>
      </div>

      <div style={{ display: "flex", gap: 10, alignItems: "center", justifyContent: "space-between" }}>
        <div style={{ fontSize: 12, color: UI.muted }}>
          Përditësuar: {offer.updatedAt ? new Date(offer.updatedAt).toLocaleString() : "—"}
        </div>
        <Btn variant="primary" onClick={onOpen} style={{ padding: "10px 14px" }}>
          Hape →
        </Btn>
      </div>
    </div>
  );
}
