import React from "react";

export function renderOpening(type, x, y, w, h) {
  const c = "#ffffff";
  const pad = 6;

  const top = y + pad;
  const bottom = y + h - pad;
  const left = x + pad;
  const right = x + w - pad;
  const midX = x + w / 2;
  const midY = y + h / 2;

  const els = [];
  if (type === "fixed") return els;

  if (type === "turn-right") {
    els.push(<line key="tr1" x1={left} y1={midY} x2={right} y2={top} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="tr2" x1={left} y1={midY} x2={right} y2={bottom} stroke={c} strokeWidth={1.2} />);
  }

  if (type === "turn-left") {
    els.push(<line key="tl1" x1={right} y1={midY} x2={left} y2={top} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="tl2" x1={right} y1={midY} x2={left} y2={bottom} stroke={c} strokeWidth={1.2} />);
  }

  if (type === "tilt-top") {
    els.push(<line key="tt1" x1={left} y1={bottom} x2={midX} y2={top} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="tt2" x1={midX} y1={top} x2={right} y2={bottom} stroke={c} strokeWidth={1.2} />);

    const arrY = y + h * 0.5;
    const arrStart = midX + 18;
    const arrEnd = midX - 14;
    els.push(<line key="tta" x1={arrStart} y1={arrY} x2={arrEnd} y2={arrY} stroke={c} strokeWidth={1} />);
    els.push(
      <polyline
        key="ttb"
        points={`${arrEnd},${arrY} ${arrEnd + 6},${arrY - 4} ${arrEnd + 6},${arrY + 4}`}
        fill="none"
        stroke={c}
        strokeWidth={1}
      />
    );
  }

  if (type === "tilt-top-center") {
    const apexY = top + 6;
    els.push(<line key="ttc1" x1={left} y1={bottom} x2={midX} y2={apexY} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="ttc2" x1={midX} y1={apexY} x2={right} y2={bottom} stroke={c} strokeWidth={1.2} />);
  }

  if (type === "turn-right+tilt-top") {
    els.push(<line key="trtt1" x1={left} y1={bottom} x2={midX} y2={top} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="trtt2" x1={midX} y1={top} x2={right} y2={bottom} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="trtt3" x1={left} y1={midY} x2={right} y2={top} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="trtt4" x1={left} y1={midY} x2={right} y2={bottom} stroke={c} strokeWidth={1.2} />);
  }

  return els;
}
