import React from "react";
import { UI } from "../../constants/ui";

export function ToolBtn({ children, onClick, disabled, active, title }) {
  return (
    <button
      title={title}
      onClick={disabled ? undefined : onClick}
      style={{
        width: 50,
        height: 50,
        borderRadius: 14,
        border: `1px solid ${UI.border}`,
        background: disabled ? "#f1f5f9" : active ? "#dbeafe" : "#fff",
        cursor: disabled ? "not-allowed" : "pointer",
        display: "grid",
        placeItems: "center",
        boxShadow: active ? "0 10px 24px rgba(59,130,246,.18)" : "none",
      }}
    >
      {children}
    </button>
  );
}
