import React from "react";
import { UI } from "../../constants/ui";

export function Pill({ children, tone = "soft" }) {
  const map = {
    soft: { bg: "#f1f5f9", bd: UI.border, fg: UI.ink },
    blue: { bg: "#dbeafe", bd: "#bfdbfe", fg: "#1e3a8a" },
    green: { bg: "#dcfce7", bd: "#bbf7d0", fg: "#14532d" },
    orange: { bg: "#ffedd5", bd: "#fed7aa", fg: "#7c2d12" },
  };

  const t = map[tone] || map.soft;

  return (
    <span
      style={{
        display: "inline-flex",
        alignItems: "center",
        gap: 6,
        padding: "4px 10px",
        borderRadius: 999,
        background: t.bg,
        border: `1px solid ${t.bd}`,
        color: t.fg,
        fontSize: 12,
        fontWeight: 650,
        whiteSpace: "nowrap",
      }}
    >
      {children}
    </span>
  );
}
