import React from "react";

export function Ico({ children }) {
  return <span style={{ display: "inline-grid", placeItems: "center", width: 22, height: 22 }}>{children}</span>;
}

export function IconFrame() {
  return (
    <Ico>
      <svg width="22" height="22" viewBox="0 0 24 24" fill="none">
        <rect x="4" y="4" width="16" height="16" stroke="#0f172a" strokeWidth="2" rx="3" />
        <rect x="7.5" y="7.5" width="9" height="9" stroke="#64748b" strokeWidth="2" rx="2" />
      </svg>
    </Ico>
  );
}

export function IconIrregular() {
  return (
    <Ico>
      <svg width="22" height="22" viewBox="0 0 24 24" fill="none">
        <path d="M5 18V6h14v12H5Z" stroke="#0f172a" strokeWidth="2" />
        <path d="M5 9l14-3" stroke="#3b82f6" strokeWidth="2" strokeLinecap="round" />
      </svg>
    </Ico>
  );
}

export function IconSash() {
  return (
    <Ico>
      <svg width="22" height="22" viewBox="0 0 24 24" fill="none">
        <rect x="5" y="4" width="14" height="16" rx="3" stroke="#0f172a" strokeWidth="2" />
        <path d="M12 6v12" stroke="#64748b" strokeWidth="2" />
        <circle cx="9" cy="12" r="1.2" fill="#0f172a" />
      </svg>
    </Ico>
  );
}

export function IconSplit() {
  return (
    <Ico>
      <svg width="22" height="22" viewBox="0 0 24 24" fill="none">
        <rect x="5" y="4" width="14" height="16" rx="3" stroke="#0f172a" strokeWidth="2" />
        <path d="M12 5v14" stroke="#0f172a" strokeWidth="2" strokeLinecap="round" />
        <path d="M9 8h-2M9 12h-2M9 16h-2" stroke="#64748b" strokeWidth="2" strokeLinecap="round" />
      </svg>
    </Ico>
  );
}

export function IconGlass() {
  return (
    <Ico>
      <svg width="22" height="22" viewBox="0 0 24 24" fill="none">
        <path d="M7 4h10l-1 16H8L7 4Z" stroke="#0f172a" strokeWidth="2" />
        <path d="M9 9h6" stroke="#3b82f6" strokeWidth="2" strokeLinecap="round" />
      </svg>
    </Ico>
  );
}

export function IconStaticGlass() {
  return (
    <Ico>
      <svg width="22" height="22" viewBox="0 0 24 24" fill="none">
        <rect x="5" y="4" width="14" height="16" rx="3" stroke="#0f172a" strokeWidth="2" />
        <rect
          x="7.5"
          y="7"
          width="9"
          height="10"
          rx="2"
          fill="rgba(59,130,246,.25)"
          stroke="#3b82f6"
          strokeWidth="2"
        />
      </svg>
    </Ico>
  );
}

export function IconRoll() {
  return (
    <Ico>
      <svg width="22" height="22" viewBox="0 0 24 24" fill="none">
        <rect x="5" y="4" width="14" height="5" rx="2" stroke="#0f172a" strokeWidth="2" />
        <rect x="5" y="9" width="14" height="11" rx="3" stroke="#64748b" strokeWidth="2" />
        <path d="M8 12h8M8 15h8M8 18h8" stroke="#64748b" strokeWidth="2" strokeLinecap="round" />
      </svg>
    </Ico>
  );
}

export function IconT() {
  return (
    <Ico>
      <svg width="22" height="22" viewBox="0 0 24 24" fill="none">
        <path d="M6 6h12" stroke="#0f172a" strokeWidth="2" strokeLinecap="round" />
        <path d="M12 6v14" stroke="#0f172a" strokeWidth="2" strokeLinecap="round" />
        <path d="M9 20h6" stroke="#64748b" strokeWidth="2" strokeLinecap="round" />
      </svg>
    </Ico>
  );
}

export function IconGlassType() {
  return (
    <Ico>
      <svg width="22" height="22" viewBox="0 0 24 24" fill="none">
        <path d="M7 4h10l-1 16H8L7 4Z" stroke="#0f172a" strokeWidth="2" />
        <path d="M10 12h4" stroke="#0f172a" strokeWidth="2" strokeLinecap="round" />
        <path d="M12 10v4" stroke="#3b82f6" strokeWidth="2" strokeLinecap="round" />
      </svg>
    </Ico>
  );
}

/** OPENING LINES inside sash (same as original renderOpening) */
export function renderOpening(type, x, y, w, h) {
  const c = "#ffffff";
  const pad = 6;

  const top = y + pad;
  const bottom = y + h - pad;
  const left = x + pad;
  const right = x + w - pad;
  const midX = x + w / 2;
  const midY = y + h / 2;

  const els = [];

  if (type === "fixed") return els;

  if (type === "turn-right") {
    els.push(<line key="tr1" x1={left} y1={midY} x2={right} y2={top} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="tr2" x1={left} y1={midY} x2={right} y2={bottom} stroke={c} strokeWidth={1.2} />);
  }

  if (type === "turn-left") {
    els.push(<line key="tl1" x1={right} y1={midY} x2={left} y2={top} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="tl2" x1={right} y1={midY} x2={left} y2={bottom} stroke={c} strokeWidth={1.2} />);
  }

  if (type === "tilt-top") {
    els.push(<line key="tt1" x1={left} y1={bottom} x2={midX} y2={top} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="tt2" x1={midX} y1={top} x2={right} y2={bottom} stroke={c} strokeWidth={1.2} />);

    const arrY = y + h * 0.5;
    const arrStart = midX + 18;
    const arrEnd = midX - 14;
    els.push(<line key="tta" x1={arrStart} y1={arrY} x2={arrEnd} y2={arrY} stroke={c} strokeWidth={1} />);
    els.push(
      <polyline
        key="ttb"
        points={`${arrEnd},${arrY} ${arrEnd + 6},${arrY - 4} ${arrEnd + 6},${arrY + 4}`}
        fill="none"
        stroke={c}
        strokeWidth={1}
      />
    );
  }

  if (type === "tilt-top-center") {
    const apexY = top + 6;
    els.push(<line key="ttc1" x1={left} y1={bottom} x2={midX} y2={apexY} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="ttc2" x1={midX} y1={apexY} x2={right} y2={bottom} stroke={c} strokeWidth={1.2} />);
  }

  if (type === "turn-right+tilt-top") {
    els.push(<line key="trtt1" x1={left} y1={bottom} x2={midX} y2={top} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="trtt2" x1={midX} y1={top} x2={right} y2={bottom} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="trtt3" x1={left} y1={midY} x2={right} y2={top} stroke={c} strokeWidth={1.2} />);
    els.push(<line key="trtt4" x1={left} y1={midY} x2={right} y2={bottom} stroke={c} strokeWidth={1.2} />);
  }

  return els;
}
