import api from "./client";

export const PositionsApi = {
  list(offerId) {
    return api.get(`/offers/${offerId}/positions`);
  },
  sync(offerId, positions) {
    return api.post(`/offers/${offerId}/positions/sync`, { positions });
  },
  show(id) {
    return api.get(`/positions/${id}`);
  },
  update(id, payload) {
    return api.put(`/positions/${id}`, payload);
  },
  remove(id) {
    return api.delete(`/positions/${id}`);
  },
};































