import api from "./client";

export const ProfilesApi = {
  list: (params) => api.get("/profiles", { params }),
  create: (payload) => api.post("/profiles", payload),
  update: (id, payload) => api.put(`/profiles/${id}`, payload),
  remove: (id) => api.delete(`/profiles/${id}`),
};

export const IronsApi = {
  list: (params) => api.get("/irons", { params }),
  create: (payload) => api.post("/irons", payload),
  update: (id, payload) => api.put(`/irons/${id}`, payload),
  remove: (id) => api.delete(`/irons/${id}`),
};

export const GlassTypesApi = {
  list: (params) => api.get("/glass-types", { params }),
  create: (payload) => api.post("/glass-types", payload),
  update: (id, payload) => api.put(`/glass-types/${id}`, payload),
  remove: (id) => api.delete(`/glass-types/${id}`),
};

export const AccessoriesApi = {
  list: (params) => api.get("/accessories", { params }),
  create: (payload) => api.post("/accessories", payload),
  update: (id, payload) => api.put(`/accessories/${id}`, payload),
  remove: (id) => api.delete(`/accessories/${id}`),
};

// Door Panels (image upload) - supports JSON or multipart FormData
export const DoorPanelsApi = {
  list: (params) => api.get("/door-panels", { params }),
  create: (payload) => {
    const isFD = typeof FormData !== "undefined" && payload instanceof FormData;
    return api.post("/door-panels", payload, isFD ? { headers: { "Content-Type": "multipart/form-data" } } : undefined);
  },
  update: (id, payload) => {
    const isFD = typeof FormData !== "undefined" && payload instanceof FormData;
    return api.post(`/door-panels/${id}?_method=PUT`, payload, isFD ? { headers: { "Content-Type": "multipart/form-data" } } : undefined);
  },
  remove: (id) => api.delete(`/door-panels/${id}`),
};
