<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('accessories', function (Blueprint $table) {
            if (!Schema::hasColumn('accessories','name')) $table->string('name')->nullable();
            if (!Schema::hasColumn('accessories','unit')) $table->string('unit', 40)->nullable();
            if (!Schema::hasColumn('accessories','price')) $table->decimal('price', 12, 2)->default(0);
        });
    }
    public function down(): void {}
};
