<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
   public function up(): void
{
    Schema::table('positions', function (Blueprint $table) {

        if (!Schema::hasColumn('positions', 'offer_id')) {
            $table->unsignedBigInteger('offer_id')->after('id');
        }

        if (!Schema::hasColumn('positions', 'name')) $table->string('name')->nullable();
        if (!Schema::hasColumn('positions', 'color')) $table->string('color', 80)->nullable();

        if (!Schema::hasColumn('positions', 'frame_w')) $table->integer('frame_w')->nullable();
        if (!Schema::hasColumn('positions', 'frame_h')) $table->integer('frame_h')->nullable();

        if (!Schema::hasColumn('positions', 'shape_type')) $table->string('shape_type', 40)->nullable();

        if (!Schema::hasColumn('positions', 'is_door')) $table->boolean('is_door')->default(false);
        if (!Schema::hasColumn('positions', 'has_roll')) $table->boolean('has_roll')->default(false);
        if (!Schema::hasColumn('positions', 'roll_height')) $table->integer('roll_height')->nullable();

        if (!Schema::hasColumn('positions', 'glass_type_id')) $table->unsignedBigInteger('glass_type_id')->nullable();

        if (!Schema::hasColumn('positions', 'sash_count')) $table->integer('sash_count')->nullable();
        if (!Schema::hasColumn('positions', 't_profile_count')) $table->integer('t_profile_count')->nullable();

        if (!Schema::hasColumn('positions', 'top_left_offset_mm')) $table->integer('top_left_offset_mm')->nullable();
        if (!Schema::hasColumn('positions', 'top_right_offset_mm')) $table->integer('top_right_offset_mm')->nullable();

        if (!Schema::hasColumn('positions', 'extra_bottom_profile')) $table->boolean('extra_bottom_profile')->default(false);

        if (!Schema::hasColumn('positions', 'sashes')) $table->json('sashes')->nullable();
        if (!Schema::hasColumn('positions', 't_profiles')) $table->json('t_profiles')->nullable();
        if (!Schema::hasColumn('positions', 'segments_glass')) $table->json('segments_glass')->nullable();
        if (!Schema::hasColumn('positions', 'accessories')) $table->json('accessories')->nullable();
        if (!Schema::hasColumn('positions', 'view')) $table->json('view')->nullable();

        if (!Schema::hasColumn('positions', 'total')) $table->decimal('total', 12, 2)->default(0);
    });
}



    public function down(): void
    {
        // Usually you don’t rollback in dev; keeping empty is fine.
    }
};
