<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Position extends Model
{
    // ✅ IMPORTANT: use same DB connection as your migrations (your error says Connection: central)
    protected $connection = 'central';

    // easiest while building
    protected $guarded = [];

    // ✅ Cast JSON / booleans so you get arrays back in API
    protected $casts = [
        'is_door' => 'boolean',
        'has_roll' => 'boolean',
        'extra_bottom_profile' => 'boolean',

        'sashes' => 'array',
        't_profiles' => 'array',
        'segments_glass' => 'array',
        'accessories' => 'array',
        'view' => 'array',

        // If you add this column (recommended)
        'data' => 'array',

        'total' => 'decimal:2',
    ];

    public function offer()
    {
        return $this->belongsTo(Offer::class);
    }
}
