<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OfferResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        // Return all safe attributes dynamically (except timestamps)
        $attrs = $this->resource->getAttributes();
        unset($attrs['created_at'], $attrs['updated_at'], $attrs['deleted_at']);

        return [
            'id' => $this->id,
            'attributes' => $attrs,
            'positions' => PositionResource::collection($this->whenLoaded('positions')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}