<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AccessoryResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $attrs = $this->resource->getAttributes();
        unset($attrs['created_at'], $attrs['updated_at'], $attrs['deleted_at']);

        return [
            'id' => $this->id,
            'attributes' => $attrs,
        ];
    }
}