<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Tenant;

class AdminDashboardController extends Controller
{
    public function index(Request $request)
    {
        // CENTRAL metrics (only central DB)
        $tenantsCount = Tenant::count();
        $centralUsersCount = User::count();

        // Simple "revenue" placeholder:
        // Later you can replace this with real subscriptions/payments.
        $revenueTotal = 0;

        // Latest tenants list (for quick view)
        $latestTenants = Tenant::latest('created_at')
            ->take(10)
            ->get()
            ->map(function ($t) {
                return [
                    'id' => $t->id,
                    'name' => data_get($t->data, 'name', $t->id),
                    'created_at' => $t->created_at,
                    'domains' => $t->domains()->pluck('domain')->values(),
                ];
            });

        return view('dashboard', [
            'tenantsCount' => $tenantsCount,
            'centralUsersCount' => $centralUsersCount,
            'revenueTotal' => $revenueTotal,
            'latestTenants' => $latestTenants,
        ]);
    }
}
